<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ExpensestypeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Expensestype 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param expensestype primary key
 	 */
	public function delete($expensestypeid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Expensestype expensestype
 	 */
	public function insert($expensestype);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Expensestype expensestype
 	 */
	public function update($expensestype);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByExpensestypename($value);

	public function queryByExpensestypedetails($value);

	public function queryByExpensestypedate($value);

	public function queryByCondition($value);

	public function queryByUserid($value);

	public function queryByParent($value);


	public function deleteByExpensestypename($value);

	public function deleteByExpensestypedetails($value);

	public function deleteByExpensestypedate($value);

	public function deleteByCondition($value);

	public function deleteByUserid($value);

	public function deleteByParent($value);


}
?>